# BeautifulSoup 获取text

获取网页的text

```python
# -*- coding: UTF-8 -*-
from bs4 import BeautifulSoup

def fetch_text(html):
    # TODO(You): 请在此实现代码
    return result

if __name__ == '__main__':
    html = '''
        <html>
            <head>
                <title>这是一个简单的测试页面</title>
            </head>
            <body>
                <p class="item-0">body 元素的内容会显示在浏览器中。</p>
                <p class="item-1">title 元素的内容会显示在浏览器的标题栏中。</p>
            </body>
        </html>
        '''
    text = fetch_text(html)
    print(text)
```

请选出下列能**正确**实现这一功能的选项。

## template

```python
from bs4 import BeautifulSoup

def fetch_text(html):
    soup = BeautifulSoup(html, 'lxml')
    result = soup.text
    return result

def test():
    html = '''
        <html>
            <head>
                <title>这是一个简单的测试页面</title>
            </head>
            <body>
                <p class="item-0">body 元素的内容会显示在浏览器中。</p>
                <p class="item-1">title 元素的内容会显示在浏览器的标题栏中。</p>
            </body>
        </html>
        '''
    text = fetch_text(html)
    print(text)

if __name__ == '__main__':
    test()
```

## 答案

```python
def fetch_text(html):
    soup = BeautifulSoup(html, 'lxml')
    result = soup.text
    return result
```

## 选项

### A

```python
def fetch_text(html):
    soup = BeautifulSoup(html, 'lxml')
    result = soup.find_all('text')
    return result
```

### B

```python
def fetch_text(html):
    soup = BeautifulSoup(html, 'lxml')
    result = soup.find_text()
    return result
```

### C

```python
def fetch_text(html):
    soup = BeautifulSoup(html, 'lxml')
    result = soup.text()
    return result
```
